/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE;

import jpcsp.graphics.RE.BaseRenderingEngineProxy;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.VideoEngine;

public class AnisotropicFilter
extends BaseRenderingEngineProxy {
    protected static final int[] anisotropicMipmapMagFilter = new int[]{1, 1, 2, 3, 7, 7, 7, 7};
    private float maxTextureAnisotropy;
    private float textureAnisotropy;
    private boolean useTextureAnisotropicFilter;

    public AnisotropicFilter(IRenderingEngine proxy) {
        super(proxy);
    }

    public void setDefaultTextureAnisotropy(float value) {
        this.textureAnisotropy = value;
    }

    @Override
    public void startDisplay() {
        this.useTextureAnisotropicFilter = VideoEngine.getInstance().isUseTextureAnisotropicFilter();
        super.startDisplay();
    }

    @Override
    public void setRenderingEngine(IRenderingEngine re) {
        this.textureAnisotropy = this.maxTextureAnisotropy = re.getMaxTextureAnisotropy();
        super.setRenderingEngine(re);
    }

    @Override
    public void setTextureMipmapMagFilter(int filter) {
        if (this.useTextureAnisotropicFilter) {
            this.re.setTextureAnisotropy(this.textureAnisotropy);
            super.setTextureMipmapMagFilter(anisotropicMipmapMagFilter[filter]);
        } else {
            super.setTextureMipmapMagFilter(filter);
        }
    }
}

